<?php

function checkBinanceConnection() {
    // Endpoint de Binance para validar la conexión
    $url = "https://fapi.binance.com/fapi/v1/time";

    // Inicializar cURL
    $ch = curl_init($url);

    // Configurar opciones de cURL
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Tiempo de espera de 10 segundos

    // Ejecutar solicitud
    $response = curl_exec($ch);

    // Verificar errores de cURL
    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return [
            'success' => false,
            'message' => "Error al conectar con Binance API: $error",
        ];
    }

    // Verificar el código de respuesta HTTP
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode == 200) {
        return [
            'success' => true,
            'message' => "Conexión exitosa con Binance API.",
            'response' => json_decode($response, true),
        ];
    } else {
        return [
            'success' => false,
            'message' => "Error en la conexión con Binance API. Código HTTP: $httpCode",
            'response' => json_decode($response, true),
        ];
    }
}

// Llamar a la función y mostrar el resultado
$result = checkBinanceConnection();
echo json_encode($result, JSON_PRETTY_PRINT);